/************************************************************/
/* PROJECT NAME: Vectored Interrupt                         */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin      tmartin@hitex.co.uk          */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V1.3		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2004						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example configuration of VIC for vectored interrupt  	*/
/*															*/
/* Demonstrates serving the external interrupt as a 		*/ 
/* vectored interrupt										*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include <LPC21xx.H>
void EXTINTVectoredIRQ (void)__irq;

void main (void)
{

IODIR1			= 0x000FF000;						//Set the LED pins as outputs
PINSEL0 		= 0x20000000;						//Enable the EXTINT1 interrupt

VICVectCntl0 	= 0x0000002F;  						//select a priority slot for a given interrupt

VICVectAddr0 	= (unsigned)EXTINTVectoredIRQ;		//pass the address of the IRQ into the VIC slot

VICIntEnable 	= 0x00008000;						//enable interrupt

while(1)
{
;													//Idle
}

}

void EXTINTVectoredIRQ (void)  __irq
{

IOSET1 	= 0x000FF000;								//Set the LED pins
EXTINT  = 0x00000002;								//Clear the peripheral interrupt flag
VICVectAddr = 0x00000000;							//Dummy write to signal end of interrupt
}
